/***************************************************************
 * C++ source
 *
 * File : 	SplineWeights.cc
 *
 * Module :	SplineWeights
 *
 * Author : 	A M Baumberg
 *
 * Creation Date : Tue Jan 11 16:21:52 1994 
 *
 * Comments : 	
 *
 ***************************************************************/


#include "SplineWeights.h"

namespace ReadingPeopleTracker
{

// definition and initialisation of static member variables
const unsigned int SplineWeights::NO_SUBDIVISIONS = 2;

//  void SplineWeights::setup_spline_weights()
//  {
//      if (spline_weights == NULL)
//  	spline_weights = new SplineWeights();
//  }

realno SplineWeights::B_func(int i, realno u)
{
    u -= (i-2);
    if (u < 0) u += Profile::NO_CONTROL_POINTS;
    else if (u >= Profile::NO_CONTROL_POINTS) u -= Profile::NO_CONTROL_POINTS;
    realno v = u - ((int) u);
    if (u >= 4) return 0;
    else if (u < 1) return (v * v * v) / 6;
    else if (u < 2) return ((1 + 3 * v * (1 + v * ( 1 - v))) / 6);
    else if (u < 3) return (4 + 3 * v * v * ( v - 2 ))/6;
    else return ((1 + v * (3 * (v - 1) - v * v)) / 6);
}

realno SplineWeights::dB_func(int i, realno u)
{
    u -= (i-2);
    if (u < 0) u += Profile::NO_CONTROL_POINTS;
    else if (u >= Profile::NO_CONTROL_POINTS) u -= Profile::NO_CONTROL_POINTS;
    realno v = u - ((int) u);
    if (u >= 4) return 0;
    else if (u < 1) return (v * v) / 2;
    else if (u < 2) return (1 + 2 * v - 3 * v * v) / 2;
    else if (u < 3) return (3 * v * v - 4 * v) / 2;
    else return (-1 + 2 * v - v * v) / 2;
}

realno SplineWeights::ddB_func(int i, realno u)
{
    u -= (i-2);
    if (u < 0) u += Profile::NO_CONTROL_POINTS;
    else if (u >= Profile::NO_CONTROL_POINTS) u -= Profile::NO_CONTROL_POINTS;
    realno v = u - ((int) u);
    if (u >= 4) return 0;
    else if (u < 1) return v;
    else if (u < 2) return 1  - 3 * v;
    else if (u < 3) return 3 * v - 2;
    else return  1  - v;
}

SplineWeights::SplineWeights(unsigned int n)
{
    if (n == 0)
	nsubs = NO_SUBDIVISIONS;
    else
	nsubs = n;

    realno step = 1.0 /  (realno) n; realno u = 0;
    w0 = new realno[n];
    w1 = new realno[n];
    w2 = new realno[n];
    w3 = new realno[n];
    dw0 = new realno[n];
    dw1 = new realno[n];
    dw2 = new realno[n];
    dw3 = new realno[n];
    
    for (int i = 0; i < n; i++)
    {
	w0[i] = B_func(-1,u);
	w1[i] = B_func(0,u);
	w2[i] = B_func(1,u);
	w3[i] = B_func(2,u);
	dw0[i] = dB_func(-1,u);
	dw1[i] = dB_func(0,u);
	dw2[i] = dB_func(1,u);
	dw3[i] = dB_func(2,u);
	u += step;
    } 
}

} // namespace ReadingPeopleTracker
