//
// SplineMatrix.h
// 
// class with methods to convert a RegionBoundary to spline form.
//
// (added reparametrisation optimisation method 14/12/94)
//
//

#include <stdlib.h>
#include <cstdio>
#include <math.h>

#include "SplineMatrix.h"
#include "SplineWeights.h"
#include "Profile.h"
#include "text_output.h"

namespace ReadingPeopleTracker
{

SplineMatrix::SplineMatrix(unsigned int nsubs)
    : NagMatrix(Profile::NO_CONTROL_POINTS, Profile::NO_CONTROL_POINTS)
{
    
    cdebug << " SplineMatrix: building matrix... " << endl;

    // calculate the matrix 
    const unsigned int N = Profile::NO_CONTROL_POINTS;
    NagVector tempdata(N);
    realno temp;
    realno Ui;
    unsigned int i; unsigned int j; unsigned int l;
    for (l = 0; l < N; l++)
    {
	temp = 0;
	for (i = 0; i < (N*nsubs); i++)
	{
	    Ui = i / (realno) nsubs;
		temp += SplineWeights::B_func(l, Ui) * SplineWeights::B_func(0, Ui);
	}
	tempdata[l] = temp;
    }
    
    NagMatrix tmp_matrix(N, N);
    for (i = 0; i < N; i++)
	for (j = 0; j < N; j++) 
	    tmp_matrix.set(i,j, tempdata[(i - j + N) %  N]);
    tmp_matrix.invert(*this);
    
    vdata = new realno[4 * nsubs + 1];
    for (j = 0; j <= 4 * nsubs; j++)
	vdata[j] = SplineWeights::B_func(0,(j - (2 * nsubs)) / (realno) nsubs);
}

} // namespace ReadingPeopleTracker
