/*
 *   RegionSet.h
 *
 *   a class consisting of a List of `Region's
 * 
 */

#ifndef __REGION_SET_H__
#define __REGION_SET_H__

#include "List.h"
#include "Region.h"
#include "Stack.h"
#include "tracker_defines_types_and_helpers.h"

namespace ReadingPeopleTracker
{

class Image;
class Grey8Image;
class ProfileSet;

class RegionSet : public List<Region>
{
private:
    Stack *stack;
    static const unsigned int DEFAULT_MIN_REGION_SIZE;
    static const unsigned int DEFAULT_MAX_REGION_SIZE;

public:
    
    // blob id from XML Region data (available iff INRIA external motion detector is used)
    frame_id_t xml_frame_id;
    
    RegionSet()
	{
	    stack = new Stack;
	    xml_frame_id = 0;
	}
    
    ~RegionSet()
	{
	    // nothing
	}
    
    RegionSet &operator= (RegionSet &original)
	{
	    // FIXME: Stack is not copied over...  is it needed?

	    xml_frame_id = original.xml_frame_id;

	    List<Region>::operator=(original);
	    return *this;
	}
    
    
    // Grab regions with subimage data from an image
    void grab_regions_and_subimages(const Grey8Image *img,
				    unsigned int min_size = DEFAULT_MIN_REGION_SIZE,
				    unsigned int max_size = DEFAULT_MAX_REGION_SIZE,
				    bool keep_edge_regions = true);

    
    // grab all regions but don't grab region image
    void grab_regions(const Grey8Image *img,
		      unsigned int min_size = DEFAULT_MIN_REGION_SIZE,
		      unsigned int max_size = DEFAULT_MAX_REGION_SIZE,
		      bool keep_edge_regions = true);

    void merge_regions(realno dist_threshold = 0.1);
    
    // remove small regions
    void filter(realno min_region_size);
    
    
    void draw_boxes(frame_id_t min_draw_age = 0);
    void draw_boxes_in_image(Image *canvas, frame_id_t max_age);
    
    void trace_regions(); 
    
    void draw_regions(); /* draw the regions */
    void clear_window();
    
    void smooth(realno sd = 1.0, int win_sz = 5);
    
    ProfileSet *to_profiles();  // (allocates a new ProfileSet)


private:

    // private helper
    static realno bbdistance(Region *r, Region *t);  // dist between 2 blobs (regions)

};

} // namespace ReadingPeopleTracker

#endif
