/*
 *  ProfileSet -
 *  a class consisting of a list of `Profile's
 *
 */

#ifndef __PROFILE_SET_H__
#define __PROFILE_SET_H__

#include "Profile.h"
#include "List.h"
#include "Image.h"
#include "text_output.h"
#include "tracker_defines_types_and_helpers.h"

namespace ReadingPeopleTracker
{

class ActiveShapeTracker;

class ProfileSet : public List<Profile>
{
private:
    ActiveShapeTracker *tracker;
    
public:
    
    ProfileSet(ActiveShapeTracker *the_tracker = NULL)
	{
	    tracker = the_tracker;
	}
    
    ~ProfileSet()
	{
	    // nothing
	}
    
    ProfileSet &operator= (ProfileSet &original)
	{
	    tracker = original.tracker;
	    List<Profile>::operator=(original);
	    return *this;
	}
    
    Profile *operator[] (const unsigned int i)
	{
	    return List<Profile>::operator[](i);
	}
    
    void draw(frame_id_t min_draw_age = 0);
    // draw the outlines onto the image data
    void draw_in_image(Image *img, frame_id_t min_age = 0);
    
    void reflect(ProfileSet &result);
    
    void keep_ok();
    void remove_ok();
    
    void gauss_smooth(realno sd = 1.0);
    void transform(NagMatrix &H);
    void fit_to_line();
    void add_origins(Point2 new_origin = Point2(0,0));
    
    // rescale all coordinates
    void scale_coords(realno scale_fac); 
    
    // the next ones just do the appropriate action for all profiles.
    inline void map_to_model_frame()
	{
	    for (start(); current_ok(); forward())
		get_current()->map_to_model_frame();
	}
    
    inline void recenter(realno *wghts = NULL)
	{ 
	    for (ListNode<Profile> *curr = first; curr != NULL; curr = curr->next)
		curr->dat->recenter(wghts); 
	}
    
    inline void draw_filled()
	{ 
#ifndef NO_DISPLAY
	    for (ListNode<Profile> *curr = first; curr != NULL; curr = curr->next)
		curr->dat->draw_filled(); 
#endif   // #ifndef NO_DISPLAY
	}
    
    inline void normalise()
	{ 
	    for (ListNode<Profile> *curr = first; curr != NULL; curr = curr->next)
		curr->dat->normalise(); 
	}
    
    inline void display_shapes(realno ox, realno oy)
	{ 
	    for (ListNode<Profile> *curr = first; curr != NULL; curr = curr->next)
		curr->dat->display_shape(ox,oy); 
	}    
    
};

} // namespace ReadingPeopleTracker

#endif
