// PointVector.h
// 
// A Class for manipulating a vector of n Points
// stored as a vector of 2n realnos
//

#ifndef __POINT_VECTOR_H__
#define __POINT_VECTOR_H__

#include "Point2.h"
#include "NagVector.h"

namespace ReadingPeopleTracker
{

class PointVector : public NagVector
{
protected:
    
    unsigned int no_points;
    
public:
    
    PointVector() : NagVector(0,1024) { no_points = 0; }  // FIXME: size???
    PointVector(unsigned int n) : NagVector(2*n) { no_points = n; }
    ~PointVector() { }
    
    void add_point(const Point2 &pnt)
	{
	    add(pnt.x);
	    add(pnt.y);
	    no_points++;
	}
    
    Point2 *pop() { size -= 2; return &(point_data()[no_points--]); }
    Point2 *last() { return &(point_data()[no_points-1]); }
    Point2 *first() { return point_data(); }
    
    inline Point2 *point_data() const { return (Point2*) data; }
    inline Point2 *end_data() const { return &(point_data()[no_points]); }
    
    int get_no_points() { return no_points; }
    
    PointVector &operator=(PointVector &original)
	{
	    no_points = original.no_points;
	    NagVector::operator= (original);
	    return *this;
	}
    
    // utility functions
    
    void map(const realno &ax, const realno &ay, PointVector &result);
    
    
};

} // namespace ReadingPeopleTracker

#endif
