/***************************************************************
 * C++ source
 *
 * File : 	PointVector.cc
 *
 * Module :	PointVector
 *
 * Author : 	A M Baumberg
 *
 * Creation Date : Thu Feb  3 13:13:57 1994 
 *
 * Comments : 	A class for manipulating a N point vector
 *
 ***************************************************************/


#include <cstdio>
#include <cassert>

#include "PointVector.h"
#include "text_output.h"

namespace ReadingPeopleTracker
{

void PointVector::map(const realno &ax, const realno &ay, PointVector &result)
{
    assert (result.no_points >= no_points);
    
    if (result.no_points < no_points)
    {
	cerror << " bad call to PointVector::map " << endl;
	abort();
    }
    
    Point2* pnt1 = point_data();
    Point2* pnt2 = result.point_data();
    Point2* epnt = &(point_data()[no_points]);
    while (pnt1 < epnt)
    {
	*pnt2++ = Point2(ax * pnt1->x - ay * pnt1->y, 
			 ay * pnt1->x + ax * pnt1->y);
	pnt1++;
    }
}

} // namespace ReadingPeopleTracker
