///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  Observation.cc                                                           //
//                                                                           //
//  Base storage class for an observation: a Region, Profile etc             //
//                                                                           //
//  Author    : Nils T Siebel (nts)                                          //
//  Created   : Tue Oct 30 17:29:41 GMT 2001                                 //
//  Revision  : 0.0 of Tue Oct 30 17:29:41 GMT 2001                          //
//  Copyright : The University of Reading                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "Observation.h"
#include "BaseTracker.h"

namespace ReadingPeopleTracker
{

static const char *Observation_Revision = "@(#) Observation.cc, rev 0.0 of Tue Oct 30 17:29:41 GMT 2001, Author Nils T Siebel, Copyright (c) 2001 The University of Reading";

Observation &Observation::operator= (const Observation &original)
{
    source = original.source;
    is_visible = original.is_visible;
    time_first_detected = original.time_first_detected;
    time_last_detected = original.time_last_detected;
    frame_first_detected = original.frame_first_detected;
    frame_last_detected = original.frame_last_detected;
    xlo = original.xlo;
    xhi = original.xhi;
    ylo = original.ylo;
    yhi = original.yhi;
    origin = original.origin;
    width = original.width;
    height = original.height;

    return *this;
}

} // namespace ReadingPeopleTracker
