///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  HumanFeatures.h                                                         //
//                                                                           //
//  Some definitions and structures for human features such as head etc      //
//                                                                           //
//  Author    : Nils T Siebel (nts)                                          //
//  Created   : Tue Apr 17 15:57:52 BST 2001                                 //
//  Revision  : 0.1 of Thu Apr 19 12:20:49 BST 2001                          //
//  Copyright : The University of Reading                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __HUMAN_FEATURES_H__
#define __HUMAN_FEATURES_H__

#include <iostream>

#include "Observation.h"
#include "tracker_defines_types_and_helpers.h"

namespace ReadingPeopleTracker
{

class HumanFeatures : public Observation
{
public:
    HeadInfo *head;   // head data   
    
    // empty contructor and destructor
    HumanFeatures (ObservationSourceType data_source = OTHER) : Observation(data_source)
	{
	    // nothing
	};

    HumanFeatures &operator= (HumanFeatures &original);

    ~HumanFeatures()
	{
	    if ((head != NULL) && (head->head_histogram != NULL))
		delete head->head_histogram;
	};

    // draw parameters: set by ScreenOutput for now
    static bool draw_head_search_area;
    static bool draw_head_bbox;
    static bool draw_head_centre;
    static bool draw_shoulder_width;
    
    // member functions
    void draw();  // draw all detected HumanFeatures on screen

    void draw_head();   // draw head
    
};

// operators to write out HeadInfo structure and HumanFeatures class data
ostream &operator << (ostream &target, const HeadInfo &head);
ostream &operator << (ostream &target, const HumanFeatures &features);

// Warning: this one is empty now.  we need it for listimplement(HumanFeatures)
//   in HumanFeatureSet
istream &operator >> (istream &source, HumanFeatures &features);

} // namespace ReadingPeopleTracker

#endif


