///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//  HumanFeatureSet.h                                                       //
//                                                                           //
//  A list of tracked objects with detected human features such as head etc  //
//                                                                           //
//  Author    : Nils T Siebel (nts)                                          //
//  Created   : Tue Apr 17 15:57:52 BST 2001                                 //
//  Revision  : 0.1 of Thu Apr 19 12:19:58 BST 2001                          //
//  Copyright : The University of Reading                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __HUMAN_FEATURE_SET_H__
#define __HUMAN_FEATURE_SET_H__

#include "List.h"
#include "HumanFeatures.h"
#include "tracker_defines_types_and_helpers.h"

// #include "XMLSource.h"


namespace ReadingPeopleTracker
{

class HumanFeatureTracker;

class HumanFeatureSet : public List<HumanFeatures>
{
 private:
    HumanFeatureTracker *tracker;
    
 public:

    HumanFeatureSet(HumanFeatureTracker *the_tracker = NULL)
	{
	    tracker = the_tracker;
	}
    
    ~HumanFeatureSet()
	{
	    // nothing
	}

    HumanFeatureSet &operator= (HumanFeatureSet &original)
	{
	    tracker = original.tracker;
	    List<HumanFeatures>::operator=(original);
	    return *this;
	}

    void draw();   // draw all HumanFeatures in this set
    
};

} // namespace ReadingPeopleTracker

#endif


