/*
 * Boundary Points.h
 * 
 * the ordered set of points on the boundary of an object
 *
 */

#ifndef __BOUNDARY_POINTS_H__
#define __BOUNDARY_POINTS_H__

#include "Point2.h"
#include "PointVector.h"
#include "NagMatrix.h"
#include "SplineMatrix.h"

namespace ReadingPeopleTracker
{

class Profile;

class BoundaryPoints : public PointVector
{
private:
    SplineMatrix *s_matrices[6];

public:
    
    unsigned int anchor_point;
    
    BoundaryPoints() : PointVector()
	{
	    for (register unsigned int count = 0; count < 6; count++)
		s_matrices[count] = NULL;
	}
    
    ~BoundaryPoints() {}

    BoundaryPoints(unsigned int n) : PointVector(n) {}
    
    BoundaryPoints &operator= (BoundaryPoints &original) // FIXME: !tested --- nts Oct 2001
	{
	    anchor_point = original.anchor_point;
	    PointVector::operator= (original);
	    return *this;
	}
 
    void setup_default_spline_matrices();

    /* smooth the curve by convolving with a Gaussian
       standard deviation sd, window_size for convolving */
    void gauss_smooth(realno sd, unsigned int window_size = 5);
    
    /* find_best_line - finds best fit line 
       returns - (1/gradient) , origin_x, origin_y */
    void find_best_line(realno &inv_grad, realno &ox, realno &oy);
    void find_robust_best_line(realno &inv_grad, realno &ox, realno &oy);
    
    void find_end(Point2& n, Point2& origin);
    void find_ends(realno inv_grad, realno ox, realno oy);
    void find_end_highest(Point2& n, Point2& origin);
    
    void draw_points(int xlo = 0, int ylo = 0);
    void draw_curve(int ox = 0, int oy = 0, int step = 1);
    
    bool filter();
    bool convert_to_spline(PointVector *res);  // filter and spline
    void to_spline(PointVector *res);          // just spline, no filter 
    bool find_optimal_spline(Profile *result); // non-uniform optimal spline
    
    // alternative method: calculate a spline from an arbitrary set of Boundary points
    // without worrying about speed / efficiency
    void calculate_spline(NagVector &u_values, PointVector *data, PointVector *result);
    
    void recenter(realno, realno);

private:
    static const realno LARGE; // a large number

};

} // namespace ReadingPeopleTracker

#endif
