/***************************************************************
 * C++ source
 *
 * File : 	generate_H.cc
 *
 * Module :	generate_H
 *
 * Author : 	A M Baumberg (CoMIR)
 *
 * Creation Date : Tue Feb 21 11:56:43 1995 
 *
 * Comments : 	
 *
 ***************************************************************/


#include "NagMatrix.h"

using namespace ReadingPeopleTracker;

static const int d = 3;
static const int N = 4;

static void get_G(int n, NagMatrix& res)
{
    if (res.get_data() == NULL) res.reconstruct(d+1, N);
    res.clear(0);
    for (int i = n; i <= n+d; i++)
	res.set(i-n, i % N,1);
}

// 
// B spline matrix ...
//
//  1   4   1   0
// -3   0   3   0
//  3  -6   3   0
// -1   3  -3   1

static realno B3_data[16] = { 1.0/6.0, -3.0/6.0, 3.0/6.0, -1.0/6.0,
			      4.0/6.0, 0, -6.0/6.0, 3.0/6.0, 
			      1.0/6.0, 3.0/6.0, 3.0/6.0, -3.0/6.0,
			      0,0,0,1.0/6.0 };

static NagMatrix B3(4,4, B3_data);

static realno B2_data[9] = {1.0/2.0, -2.0/2.0, 1.0/2.0, 
			    1.0/2.0, 2.0/2.0, -2.0/2.0,
			    0.0, 0.0, 1.0/2.0};

static NagMatrix B2(3,3,B2_data);


static realno S3_data[16] = 
{ 1.0, 1.0/2.0, 1.0/3.0, 1.0/4.0,
  1.0/2.0, 1.0/3.0, 1.0/4.0, 1.0/5.0,
  1.0/3.0, 1.0/4.0, 1.0/5.0, 1.0/6.0,
  1.0/4.0, 1.0/5.0, 1.0/6.0, 1.0/7.0 };

static NagMatrix S3(4,4, S3_data);

static realno S2_data[9] = 
{ 1.0, 1.0/2.0, 1.0/3.0,
  1.0/2.0, 1.0/3.0, 1.0/4.0,
  1.0/3.0, 1.0/4.0, 1.0/5.0 };


static NagMatrix S2(3,3,S2_data);


static void get_H(NagMatrix& res)
{
    if (res.get_data() == NULL) res.reconstruct(N,N);
    res.clear(0.0);
    
    NagMatrix B_t;
    B3.transpose(B_t);
    NagMatrix S_B;
    S3.multiply(B3, S_B);
    NagMatrix BSB;
    B_t.multiply(S_B, BSB);
    
    NagMatrix G_n;
    NagMatrix G_n_t;
    NagMatrix tmp1;
    NagMatrix tmp2;
    for (int i = 0; i < N; i++)
    {
	get_G(i, G_n);
	G_n.transpose(G_n_t);
	G_n_t.multiply(BSB, tmp1);
	tmp1.multiply(G_n, tmp2);
	res.add(tmp2, res);
    }
}


int main()
{
    NagMatrix H;
    NagMatrix H_inv;
    get_H(H);
    H.output();
    H.msqrt(H_inv);
    H_inv.output();

    return 0;  // so ANSI are happy
}
