/***************************************************************
 * C - C++ Header
 *
 * File : 	default_pca_model.h
 *
 * Module :	default_pca_model
 *
 * Author : 	A M Baumberg (CoMIR)
 *
 * Creation Date : Mon Oct 28 12:27:52 1996 
 *
 * Comments : 	data for a default pedestrian shape model
 *
 ***************************************************************/


#ifndef __DEFAULT_PCA_MODEL__
#define __DEFAULT_PCA_MODEL__

#include "realno.h"

namespace ReadingPeopleTracker
{

const unsigned int default_no_control_points = 32;

realno default_mean_shape[64] = 
{0.118944, 103.702, 9.06359, 96.9765, 9.92982, 80.6433, 17.6103, 63.3491,
24.9327, 44.2636, 26.8911, 26.4984, 22.3458, 11.7248, 19.7938, -3.74384,
18.6407, -21.0352, 21.1777, -40.3376, 25.2172, -60.4499, 26.6268, -77.6721,
23.1463, -86.4137, 16.3543, -85.8315, 10.817, -77.1171, 4.8887, -66.1337,
-1.97412, -63.9593, -7.98676, -71.7509, -12.9417, -80.5733, -19.1359,
-83.6236, -24.5479, -80.3497, -25.5903, -70.8417, -23.4029, -55.9379,
-20.2174, -39.1888, -18.6125, -20.9889, -19.217, -1.92067, -21.437,
14.2498, -24.605, 29.0558, -23.6119, 46.1937, -16.7435, 63.8808, -8.38419,
81.038, -7.04068, 97.4034};

const unsigned int default_model_modes = 5;


realno default_eigenvalue_data[5] = {3002.49, 518.511, 
				     287.086, 241.707, 135.981};


realno default_eigenvector_data[320] = 
{ -0.0193856, 0.040856, 0.0379109, 0.0447484, -0.0476274, 0.0153809,
0.0834501, 0.0561481, 0.0646768, 0.0274428, 0.0609979, -0.000839321,
0.0440385, -0.0227977, 0.0220097, 0.0620605, -0.056924, 0.0356087,
-0.0883784, 0.00367418, -0.216107, 0.0148432, -0.282635, 0.0623393,
-0.160432, 0.057458, -0.136915, -0.0824008, -0.102762, -0.245525,
-0.0705681, -0.44761, 0.0262273, -0.476733, 0.0840015, -0.342905,
0.0791671, -0.15689, 0.108208, 0.0280346, 0.192824, 0.107372,
0.249421, 0.0998448, 0.19484, 0.0256149, 0.115136, 0.0194146,
0.0348542, 0.00742826, 0.00366319, 0.0417819, -0.0381695, -0.0283573,
-0.0859768, -0.0234272, -0.0689597, -0.0020942, -0.0848643, 0.0632001,
0.026798, -0.000469831, -0.00801111, 0.0217103, -0.0550204, -0.0269027,
-0.0326345, 0.0576505, 0.0470776, 0.0666883, -0.0208509, -0.00841281,
0.0104614, 0.0425115, 0.0468419, -0.032037, -0.0388318, 0.0642733,
-0.00251073, 0.0862554, 0.0923192, 0.0155262, 0.0692309, 0.0334305,
-0.0972081, -0.0414358, -0.0923112, -0.0734044, 0.101691, -0.206538,
0.0486812, -0.346556, 0.019396, -0.449156, 0.084292, -0.290615,
0.152212, 0.0899746, 0.0474278, 0.365697, -0.0992658, 0.499247,
0.0319572, 0.348806, 0.0241816, 0.153925, -0.170342, 0.0599412,
-0.0898512, 0.00496558, 0.0583859, 0.00307367, 0.0542444, -0.0725149,
0.046643, -0.042829, -0.0427674, -0.103287, -0.0232757, -0.0812294,
-0.00506813, -0.0393849, 0.0161078, -0.0785459, 2.30688e-05, -0.0161516,
-0.0735953, 0.00604099, 0.0151465, 0.0652394, -0.0101625, -0.0114502,
-0.0582467, -0.0365243, 0.16329, -0.064144, 0.275424, -0.0872481,
0.540527, -0.363263, -0.172116, 0.338702, 0.01116, 0.198194,
-0.153663, 0.0643371, -0.182225, 0.110839, 0.0252583, 0.100576,
0.0944702, -0.0738432, -0.0447495, -0.145631, -0.00413182, -0.0337456,
0.109489, -0.058714, -0.0114418, 0.0800258, -0.043064, 0.142151,
0.0364816, 0.0843393, -0.081921, 0.0105266, 0.0338446, -0.246464,
-0.0973552, -0.160272, -0.0386022, -0.127085, 0.0567332, 0.0548873,
0.167712, 0.0726002, 0.104528, 0.165934, -0.0432809, 0.151409,
0.0783584, 0.244561, -0.444089, -0.346067, -0.264816, -0.174703,
-0.200964, -0.0772846, 0.0155423, 0.00976139, 0.112958, -0.0234495,
-0.0554671, -0.0277349, 0.0537401, 0.0648208, 0.0115186, 0.0299228,
0.0010436, 0.159808, 0.0344755, 0.110236, 0.0214434, 0.209242,
0.277908, -0.171575, 0.173427, -0.0323112, 0.343451, 0.0485644,
0.335846, -0.0529147, -0.0860651, -0.0924162, -0.188405, -0.124918,
-0.10796, -0.166844, -0.191558, -0.165289, -0.0322535, 0.172881,
0.0283117, 0.386997, -0.0306164, 0.0938063, -0.0635653, -0.269728,
-0.140144, -0.0999962, -0.0740288, 0.143674, 0.102038, 0.111242,
-0.0772675, 0.136952, -0.0632095, 0.195152, 0.0580802, 0.156425,
0.0838973, 0.0854411, -0.0802742, -0.151252, -0.204914, -0.287955,
-0.0655579, 0.00371814, -0.232103, -0.071301, -0.319364, -0.0101337,
0.0603564, -0.16822, 0.0036646, -0.0450635, -0.0161277, -0.106491,
-0.128634, 0.0544109, 0.224753, 0.138799, -0.380391, -0.138276,
-0.149077, 0.0291199, 0.0241634, -0.0347982, 0.015535, -0.0654438,
-0.0951955, 0.154277, 0.185743, 0.00855463, 0.118949, -0.0984712,
0.00887383, -0.0710656, -0.0774528, 0.118505, 0.151092, 0.175038,
-0.0468275, 0.146283, -0.188879, 0.107634, -0.0266054, -0.13694,
0.106131, -0.30527, 0.0468603, -0.1633, -0.283174, 0.106796,
-0.243726, 0.0647706, -0.2485, -0.0439657, -0.354027, -0.0714959,
-0.14853, 0.000801452, 0.326167, 0.0621825, 0.331413, -0.0502626,
0.286003, 0.0166488, 0.268207, 0.277353, -0.0957575, -0.231837,
-0.0923759, -0.0798822, 0.0457098, -0.132368, -0.194361, 0.0837659,
0.104962,   -0.0503618}; 

} // namespace ReadingPeopleTracker

#endif
