/*
 * ProfileSequence.h
 *
 * This class handles the ProfileSets  stored on file
 *
 */

#include <iostream>

#include "NagVector.h"

namespace ReadingPeopleTracker
{

class MeanProfile;
class PCAclass;

class ProfileSequence
{
protected:
    
    unsigned char filename[100];
    NagVector weights;
    double pscale;

    // former configuration variables, constant for now (nts 2001--2002)
    static realno NO_DEVIATIONS = 1.6;
    static unsigned int NO_SHAPE_MODES = 10;
    static unsigned int WAIT_TIME = 50;

public:
    
    unsigned int no_ctrl_pnts;
    MeanProfile *mean;
    PCAclass *pca;
    
    ProfileSequence(char *name, char *model_name = NULL);
    ~ProfileSequence();
    
    void calculate_mean();
    void do_analysis();
    void display_shapes(Point2 shape_origin);
    void display_mode(int &mode);
    void random_walk(int no_modes);
    void align(char *file_out = NULL);
    void track(char *file_out = NULL);
    void reflect(char *file_out = NULL);
    void halve(char *file_out = NULL);
    void edit_shapes(Point2 shape_origin, char *file_out_name = NULL);
    void center(char *file_out = NULL);
   
private:
    
    // private helpers
    void setup_weights();
    bool align_profile(Profile &var);
    void convert_to_matrix(NagMatrix &training_matrix,
			   realno use_fraction = 1.01);
    unsigned int count_profiles();
    
    bool get_next_chain(ProfileSet &prf_chain, unsigned int &last_ref, ifstream &data_in);
    void reset_window(realno &ox, realno &oy, unsigned int mode);

};

} // namespace ReadingPeopleTracker
