/*
 * PCAclass
 * 
 * a class for carrying out Principal Component Analysis on
 * arbitrary data
 *
 * uses NagVector class as general data item
 */

#ifndef __PCA_CLASS_H__
#define __PCA_CLASS_H__

#include <limits.h>
#include <fstream>

#include "NagMatrix.h"

namespace ReadingPeopleTracker
{

class PCAclass
{
// added 24/10/95
// minimum covariance entry threshold the covariance matrix to remove chance correlations
    static realno MIN_COV_ENTRY;

public:
  unsigned int no_processed;
  unsigned int data_size;
  unsigned int max_n;

  NagMatrix covariance;
  NagMatrix change_covariance;
  
  NagVector mean;
  NagVector eigenvalues; // vector of eigenvalues
  NagMatrix eigenvectors; // matrix of eigenvectors
  NagVector weights; // set of weights

  NagVector noise_model;

// constructors 

  PCAclass (unsigned int size, unsigned int max = UINT_MAX);
  PCAclass (char *filename, unsigned int max = UINT_MAX);

// data access functions

  realno get_eval(const unsigned int i)
    { return eigenvalues[data_size - i]; }
  realno *get_evec(const unsigned int i)
    { return &(eigenvectors[(data_size - i)
			    * data_size]) ; }
  realno get_noise_model(const unsigned int i)
    { return noise_model[(data_size - i)]; }
  
  realno *cov(const unsigned int i, const unsigned int j) 
    { return covariance.get(i,j); }

// utility functions

  realno Hdot(const NagVector &v1, const NagVector &v2);  
  void reset_n() { no_processed = 0; }

  void process_cov(const NagVector &new_data);
  void process_cov(const NagVector &new_data, const NagVector &new_change_data);
  void add_noise(const realno noise_var, unsigned int no_spline_pnts = 0);
  void get_noise_model();

  void process_mean(NagVector &new_data);
  //void process_all(NagVector &new_data);
  
  // copy upper triangle of covariance matrix
  // into lower triangle 
  void restore_covariance();

  void get_evals();
  void get_mode(unsigned int, realno, NagVector &result);

  void adjust_mode(unsigned int, realno, NagVector &result);
  void map_to_shape(unsigned int, NagVector &result, realno max_distance = 30);
  void map_to_model(unsigned int, NagVector &shape, NagVector &result);
  realno map_to_mode(unsigned int index, NagVector &shape);
};


ostream &operator<<(ostream&, PCAclass&);
istream &operator>>(istream&, PCAclass&);  

} // namespace ReadingPeopleTracker

#endif


