/*
 * MeanProfile.h
 * 
 * class for calculating an updated mean profile
 *
 */

#include <limits.h>

#include "NagMatrix.h"
#include "ProfileSet.h"

namespace ReadingPeopleTracker
{

class MeanProfile : public Profile
{
public:
    
    int no_processed;
    int max_n;
    
    NagMatrix mean_squares;
    NagMatrix mean_distances;
    
    void reset_mean();
    
    MeanProfile(int max = INT_MAX) : Profile(),
				     mean_squares(Profile::NO_CONTROL_POINTS,
						  Profile::NO_CONTROL_POINTS),
				     mean_distances(Profile::NO_CONTROL_POINTS,
						    Profile::NO_CONTROL_POINTS)
	{
	    max_n = max;
	    reset_mean();
	}
    
    //MeanProfile(istream &data_in);
    
    void calculate_mean(istream &data_in);
    void update(const Profile *NewProfile);
    void update(Profile &NewProfile) { update(&NewProfile); }
    void update(ProfileSet &NewProfileSet);
};

} // namespace ReadingPeopleTracker
