/*
 * MeanProfile.cc
 * 
 * class for calculating an updated mean profile
 *
 */


#include "MeanProfile.h"

#include "tracker_defines_types_and_helpers.h"  // for SQUARE

namespace ReadingPeopleTracker
{

void MeanProfile::update(const Profile *new_profile)
{
    no_processed++;
    
    if (no_processed > max_n)
	no_processed = max_n;
    
    origin += (new_profile->origin - origin) / no_processed;
    width += (new_profile->width - width) / no_processed;
    height += (new_profile->height - height) / no_processed;
    
    *this += (*new_profile - *this) / no_processed;
//    *this += (*new_profile - const_cast<const NagVector &>(*this)) / no_processed;
    Point2 d;
    for (int i = 0; i < Profile::NO_CONTROL_POINTS; i++)
    {
	for (int j = 0; j < Profile::NO_CONTROL_POINTS; j++)
	{
	    d = new_profile->spline[i] - new_profile->spline[j];
	    *mean_squares.get(i,j) += 
		(d.length2() - *mean_squares.get(i,j)) 
		/ no_processed;
	    *mean_distances.get(i,j) +=
		(fabs(d.length()) - *mean_distances.get(i,j))
		/ no_processed;	
	}
    }
}

void MeanProfile::update(ProfileSet &new_data_set)
{
    Profile reflected;
    for (ListNode<Profile> *curr = new_data_set.first; curr != NULL; curr =
	     curr->next)
    {
	update(curr->dat);
	//update(curr->dat->reflect(&reflected));
    }
    
}

void MeanProfile::reset_mean()
{
    no_processed = 0; 
    mean_squares.clear();
    mean_distances.clear();
    clear();
}    

} // namespace ReadingPeopleTracker
