/***************************************************************
 * C - C++ Header
 *
 * File : 	H_metric.h
 *
 * Module :	H_metric
 *
 * Author : 	A M Baumberg (CoMIR)
 *
 * Creation Date : Tue Feb 21 15:20:53 1995 
 *
 * Comments : 	
 *
 ***************************************************************/

// turned into a static class by  nts  Thu Mar 28 17:23:23 GMT 2002

#include "NagMatrix.h"
#include "EnvParameter.h"

namespace ReadingPeopleTracker
{

// completely static class

class HMetric
{
public:
    static NagMatrix *get_strain_matrix();
    static EnvParameter points_only;
    
    static NagMatrix H_metric;
    static NagMatrix H_root;
    static NagMatrix H_inv_root;
    static NagMatrix Strain_Matrix;
    
    static NagMatrix *get_H() { return &H_metric; }
    static NagMatrix *get_H_root() { return &H_root; }
    static NagMatrix *get_H_inv_root() { return &H_inv_root; }
    
    static const unsigned int d;

    static void get_G(unsigned int n, NagMatrix &res, unsigned int N);
    static realno B3_data[16];
    static realno dB3_data[16];
    static realno B2_data[9];
    static realno S3_data[16];
    static realno S2_data[9];

    static void setup_H_metric(unsigned int N2);
    static void setup_H_metric(NagVector &mean_prf);
    static void setup_H(unsigned int N2, NagMatrix &res);
    
    static NagMatrix G;
    static NagMatrix G_t;
    static NagMatrix dG;

    static void get_H(NagVector &prf, NagMatrix &H);
    static void setup_split_matrix(unsigned int N2, NagMatrix &Sm);
    static void build_covariance_matrix(NagMatrix &cov, unsigned int ncp, unsigned int nsp = 0);

};

} // namespace ReadingPeopleTracker
