////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  xml_write.cc                                                              //
//                                                                            //
//  Test program for the XMLWriter class, producing XML output                //
//                                                                            //
//  Author    : Rmi Belin (rb)  supervised by  Nils T Siebel (nts)           //
//  Created   : Wed Jun 13 15:55:57 BST 2001                                  //
//  Revision  : 1.0 of Thu Aug 02 11:03:30 BST 2001                           //
//  Copyright : The University of Reading                                     //
//                                                                            //
//  Changes:                                                                  //
//   rb+  rev 1.0: initial working revision   Thu Aug 02 11:03:30 BST 2001    //
//   nts:          some small changes                                         //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

#include <util/PlatformUtils.hpp>
#include <dom/DOM_Node.hpp>
#include "XMLWriter.h"
#include "XMLSource.h"

static const char *xml_write_Revision = "@(#) xml_write.cc, rev 1.0 of Thu Aug 02 11:03:30 BST 2001, Author Rmi Belin, Copyright (c) 2000--2001 The University of Reading";

int main(int argc, char** argv)
{
    // Initialize the XML4C2 system

    try
    {
        XMLPlatformUtils::Initialize();
    }

    catch(const XMLException& toCatch)
    {
        cerr << argv[0] << ": Error during Xerces-c initialization." << endl
             << "  Exception message: "
             << DOMString(toCatch.getMessage()) << endl;
        return 1;
    }

    // fill data structures with some example data
    XHRecording_attr XHR;
    XHR.site = "STIB";
    XHR.session = 5;
    XHR.date = "13/07/00";

    XHVideo XHV;
    XHV.start_frame = 2;
    XHV.end_frame = 3;
    XHV.step = 1;
    XHV.fps = 5;

    XHImage XHI;
    XHI.xdim = 768;
    XHI.ydim = 576;
    XHI.colour = 1;

    Software XHS;
    XHS.name="Reading People Tracker";
    XHS.platform="Linux";
    XHS.version=0.03;

    XHMotion_detector XHM;
    XHM.name="INRIA Motion Detector";
    XHM.platform="Linux";
    XHM.version=0.03;
    XHM.run_date="08/06/01";

    // the first alternative will write to cout, the second to the named file
    // DOCBuilder* DocBuilder = new DOCBuilder("people_tracker-example.xml");
    DOCBuilder* DocBuilder = new DOCBuilder();

    HeaderBuilder* HBuilder = DocBuilder->set_header();

    HBuilder->set_attr_recording(XHR);
    HBuilder->add_camera(2);
    HBuilder->add_camera(4);
    HBuilder->add_camera(16);

    HBuilder->set_attr_video(XHV);
    HBuilder->set_attr_image(XHI);
    HBuilder->set_attr_software(XHS);
    HBuilder->set_motion_detector(XHM);

    mobile_attr Mobile1_attr;
    Mobile1_attr.id = 8;
    Mobile1_attr.start_time = 966643000;
    Mobile1_attr.end_time = 966644600;

    mobile_attr Mobile2_attr;
    Mobile2_attr.id = 7;
    Mobile2_attr.start_time = 966643050;
    Mobile2_attr.end_time = 966644640;

    SequenceBuilder* SeqBuilder = DocBuilder->set_sequence();

    SeqBuilder->add_frame("/advisor/video/TMB/c00/test/SAGFAM00000000.jpg");
    unsigned int frame_id = 
	SeqBuilder->add_frame("/advisor/video/TMB/c00/test/SAGFAM00000038.jpg");
    SeqBuilder->add_frame("/advisor/video/TMB/c00/test/SAGFAM00000118.jpg");

    SeqBuilder->Frame(0)->add_mobile(Mobile1_attr);
    SeqBuilder->Frame(0)->add_mobile(Mobile2_attr);
    SeqBuilder->Frame(frame_id)->add_mobile(Mobile2_attr);

    track_attr track1_attr;
    track1_attr.status = 4;
    track1_attr.t_confidence = 0.5;

    track_attr track2_attr;
    track2_attr.status = 16;
    track2_attr.t_confidence = 0.5;

    SeqBuilder->Frame(0)->Mobile(7)->set_attr_track(track1_attr);
    SeqBuilder->Frame(0)->Mobile(8)->set_attr_track(track2_attr);
    SeqBuilder->Frame(38)->Mobile(7)->set_attr_track(track2_attr);

    parent_mobile parent1;
    parent1.mobile_id = 4;
    parent1.p_confidence = 0.1;
    parent1.frame_id = 2;

    parent_mobile parent2;
    parent2.mobile_id = 5;
    parent2.p_confidence = 0.5;
    parent2.frame_id = 2;

    parent_mobile parent3;
    parent3.mobile_id = 8;
    parent3.p_confidence = 0.7;
    parent3.frame_id = 2;

    SeqBuilder->Frame(38)->Mobile(7)->add_parent_mobile(parent1);
    SeqBuilder->Frame(0)->Mobile(7)->add_parent_mobile(parent2);
    SeqBuilder->Frame(0)->Mobile(7)->add_parent_mobile(parent1);
    SeqBuilder->Frame(0)->Mobile(8)->add_parent_mobile(parent3);

    // this reads the original blob data from the specified file
    XMLSource* xml_source =
	new XMLSource("/advisor/XML/examples/motion_detector-example.xml");
    XMLSequence* sequence = xml_source->get_sequence();

    if (sequence == NULL)
    {
	cerr << endl << argv[0]
	     << ": could not get region data from XML Sequence. " << endl
	     << " Exiting." << endl;
	exit(1);
    }
    
    sequence->goto_frame(100);
    XMLFrame* frame = sequence->get_current_frame();
    XMLBlob *blob1 = frame->get_a_blob(1);
    XMLBlob *blob2 = frame->get_a_blob(0);

    SeqBuilder->Frame(0)->Mobile(7)->add_blob(blob1);
    SeqBuilder->Frame(0)->Mobile(7)->add_blob(blob2);

    SeqBuilder->Frame(38)->Mobile(7)->add_blob(blob2);

    combined_blob_attr c_blob1;
    c_blob1.blob_id=1;
    c_blob1.frame_id=2;
    c_blob1.camera_id=2;

    combined_blob_attr c_blob2;
    c_blob2.blob_id=4;
    c_blob2.frame_id=2;
    c_blob2.camera_id=4;

    SeqBuilder->Frame(0)->Mobile(7)->set_best_camera(2);
    SeqBuilder->Frame(0)->Mobile(8)->set_best_camera(5);
    SeqBuilder->Frame(38)->Mobile(7)->set_best_camera(1);

    SeqBuilder->Frame(0)->Mobile(7)->add_combined_blob(c_blob1);
    SeqBuilder->Frame(0)->Mobile(7)->add_combined_blob(c_blob2);

    SeqBuilder->Frame(0)->Mobile(8)->add_combined_blob(c_blob2);

    SeqBuilder->Frame(38)->Mobile(7)->add_combined_blob(c_blob1);

    DocBuilder->WriteFile();

    return 0;
}
