/*
 
*/
/* test program */
#include <iostream>
#include <stdio.h>
#include <getopt.h>                                                           
#include "XMLSource.h"

#define USAGE "read_xml -f filename \
-f filename_string : input options \n"

int main(int argc, char** argv)
{
    char* filename;
    int c;

    while ((c = getopt(argc, argv, "if:")) != EOF)
	switch(c)
	{
	    
	case 'i':
	    break;
	    
	case 'f':
	    filename = optarg;
	    break;
	    
	default:
	    fprintf(stderr,USAGE);
	    exit(1);
	} 
    
    // Initialise XMLSource object
    XMLSource xsour( filename );
    cout << xsour;
    /***********************************************************************
    // Get its header and show the header's content:
    XMLHeader xhead = xsour.get_header();
    Recording recording = xhead.get_attr_recording(); 
    cout << "Print-out of XML Motion-Detector Header information:\n";
    cout << "recording:  " << endl;
    cout << "site=" << recording.site << endl;
    cout << "session=" << recording.session << endl;
    cout << "date=" << recording.date << endl;
    cout << "camera=" << recording.camera << endl << endl;

    Video video = xhead.get_attr_video();
    cout << "video:  " << endl;
    cout << "start frame=" << video.start_frame << endl;
    cout << "end frame=" << video.end_frame << endl;
    cout << "step=" << video.step << endl;
    cout << "frames per second=" << video.fps << endl << endl;

    Image im = xhead.get_attr_image();
    cout << "image:  " << endl;
    cout << "xdim=" << im.xdim << endl;
    cout << "ydim=" << im.ydim << endl;
    cout << "colour=" << im.colour << endl << endl;

    Software microsoft = xhead.get_attr_software(); 
    cout << "software:  " << endl;
    cout << "name=" << microsoft.get_name() << endl;
    cout << "platform=" << microsoft.get_platform() << endl;
    cout << "version=" << microsoft.get_version() << endl;
    cout << "run date=" << microsoft.get_run_date() << endl << endl;
    
    Parameters parameters = microsoft.get_software_parameters();
    cout << "software parameters:  " << endl;
    cout << "md_type=" << parameters.md_type << endl;
    cout << "num_bg_images=" << parameters.num_bg_images << endl;
    cout << "context=" << parameters.context << endl;
    cout << "threshold=" << parameters.threshold << endl << endl;
    
    // Get sequence
    XMLSequence* xseq = xsour.get_sequence();
    XMLSequence_attr seq_attr = xseq->get_sequence_attr();
    cout << "Print Motion Sequence Attributes:\n";
    cout << "Number of frames = " << seq_attr.num_frames << endl;
    cout << "Starting frame ID = " << seq_attr.start_frame_id << endl;
    cout << "Ending frame ID = " << seq_attr.end_frame_id << endl;
    cout << "Frame ID Increment = " << seq_attr.frame_id_increment << endl << endl;
    
    int id = xseq->get_current_frame_id();
    cout << "This frame's ID in the sequence is " << id << endl;

    xseq->goto_next_frame();
    id = xseq->get_current_frame_id();
    cout << "This frame's ID in the sequence is " << id << endl;

    xseq->reset_sequence();
    id = xseq->get_current_frame_id();
    cout << "This frame's ID in the sequence is " << id << endl << endl;

    // Look through frames:
    int sid = seq_attr.start_frame_id;
    int eid = seq_attr.end_frame_id;
    int inc = seq_attr.frame_id_increment;

    for (int i=sid; i<=eid; i=i+inc)
      {
	XMLFrame* xframe = xseq->get_frame_with_id(i);
	cout << *xframe;
      }
    *******************************************************************/

    return 0;
}


