/* test program */

#include "Image.h"
#include "ImageSource.h"
#include <stdio.h>
#include <getopt.h>
#include "ProfileSet.h"
#include "MovieStore.h"
#include "Grey8Image.h"
#include "utils.h"
#include "imgsrc_utils.h"
#include "GroundPeopleTracker.h"

#include "icons.h"

#define USAGE "quick_ground_track -i options [-p file] [-q] \n\
-i input image options (-i help for details) \n\
-p parameter file \n\
-q quiet mode -- display no images \n"



int MAX_OBJECTS = 
Configuration.register_int("MAX_OBJECTS", 8,
		     &MAX_OBJECTS,  false,
		     "main", 
		     "The maximum number of silhouettes to track");



int main(int argc, char** argv)
{
    Profile::draw_colour = true;
    Profile::draw_boxes = false;
    
    // remove the following 2 lines to draw the silouhette as splines 
    // rather than just bounding rectangles
    Profile::draw_spline = false;
    Profile::draw_rectangle = true;
    
    bool show_images = true;
    char *parameter_file = NULL;
    char* output_image = NULL;
    ImageSource* input_source = NULL;
    
    int c;
    while ((c = getopt(argc, argv, "i:p:q")) != EOF)
	switch(c)
	{
	case 'i':
	    input_source = get_live_or_movie_feed(optarg);
	    break;
	    
	case 'p':
	    parameter_file = optarg;
	    break;
	    
	case 'q':
	    show_images = false;
	    break;
	    
	case '?':
	default:
	    fprintf(stderr, USAGE);
	    exit(1);
	}
    
    Configuration.parse_parameter_file(parameter_file);
    
    // set default icon for windows...
    Configuration.set_icon(quick_ground_track_icon_16);
    
    Configuration.create_interface(argc, argv);
    
    ImageSource& vidsrc = *input_source;
    TrackedProfileSet curr_profiles; // pedestrian silhouettes
    
    
    GroundPeopleTracker* people_tracker = new
	GroundPeopleTracker(&vidsrc, NULL, &curr_profiles,
			    NULL);
    
    if (show_images)
	vidsrc.display();
    
    /********************************************************************/
    /*                                                                  */
    /*                      Main Loop                                   */
    /*                                                                  */
    /********************************************************************/
    
    while (vidsrc.get_next() != NULL) 
    {
	people_tracker->MainLoop(MAX_OBJECTS);
	if (show_images)  
	{
	    vidsrc.display();
	    curr_profiles.draw();
	}  
	else
	    fprintf(stderr," frame %li \n", vidsrc.get_frame_id());
	
	TrackedProfileSet filtered = 
	    curr_profiles.filter_out_short(GroundPeopleTracker::SMALL_NO_FRAMES);
	
	cout << flush << filtered << flush;
	printf("*** frame %4li  ---  time %6.2f sec ***\n",
	       vidsrc.get_frame_id(),
	       (float) vidsrc.get_current_timestamp() / 1000);
	

	filtered.delete_all();     						  
    }
    
    return 0;
    /********************************************************************/
}

// Local Variables:
// compile-command: "make quick_ground_track"
// End:
