/***************************************************************
 * C++ source
 *
 * File : 	ambpnmscale.cc
 *
 * Module :	ambpnmscale
 *
 * Author : 	A M Baumberg (CoMIR)
 *
 * Creation Date : Thu Aug  8 14:09:18 1996 
 *
 * Comments : 	
 *
 ***************************************************************/


/* include files */
#include "NagMatrix.h"
#include "Image.h"
#include "PnmSource.h"
#include "utils.h"

#define USAGE "pnmRtoL -xscale x -yscale y -xoffset ox -yoffset oy \
-width w -height -h [-vflip]\n\
xscale, yscale, xoffset, yoffset refer to the L to R mapping\n\
width, height refer to the output image size\n"


int main(int argc, char** argv)
{
  FILE* instrm = stdin;
  int i = 0;
  realno xscale = 1.0, yscale = 1.0, xoffset = 0.0, yoffset = 1.0;
  int width = 352, height = 288;
  bool do_flip = false;

  while ((++i < argc) && (argv[i][0] == '-'))
    {
      if (strcmp(argv[i],"-xscale") == 0)
	xscale = atof(argv[++i]);
      else if (strcmp(argv[i],"-yscale") == 0)
	yscale = atof(argv[++i]);
      else if (strcmp(argv[i],"-xoffset") == 0)
	xoffset = atof(argv[++i]);
      else if (strcmp(argv[i],"-yoffset") == 0)
	yoffset = atof(argv[++i]);
      else if (strcmp(argv[i],"-width") == 0)
	width = atoi(argv[++i]);
      else if (strcmp(argv[i],"-height") == 0)
	height = atoi(argv[++i]);
      else if (strcmp(argv[i],"-vflip") == 0)
	do_flip = true;
      else
	{
	  fprintf(stderr,USAGE);
	  exit(1);
	}
    }
	
  
  if (argc > i) 
    instrm = fopen(argv[i], "r");

  Image* image = read_pnm(instrm);
  // need to flip image to account for the fact that
  // the Reading image has (0,0) in top-left
  // whereas image library assumes (0,0) is bottom-left
  if (do_flip) image->flip_vertically(image);

  Image* img_out = image->copy_type(width, height);
  image->plane_project(xscale, 0.0, xoffset,
		       0.0, yscale, yoffset,
		       0.0, 0.0, 1.0, 
		       img_out);

  img_out->save_pnm(NULL);

  return 0;
}

