#include "Image.h"
#include <stdio.h>
#include <getopt.h>
#include "TrackedProfileSet.h"

#include "MovieStore.h"

#include "Grey8Image.h"
#include "imgsrc_utils.h"
#include "ActiveShapeTracker.h"

#include "icons.h"

// new stuff for multi --- nts Sep 2001
#include "Calibration.h"

#ifndef NO_DISPLAY
#ifdef DEBUG
#include <unistd.h>   // for sleep()
#endif
#endif   // #ifndef NO_DISPLAY

#define USAGE "multi_track -i options [-p file] [-l n] \
[-q] [-o file] \n\
-i input_options (-i help for details) \n\
-p parameter_file \n\
-l last frame number to process \n\
-o output numbered jpeg files, give first name \n\
-q quiet mode -- display no images \n"

int MAX_OBJECTS = 
Configuration.register_int("MAX_OBJECTS", 8,
			   &MAX_OBJECTS,  false,
			   "main", 
			   "The maximum number of silhouettes to track");


extern bool Profile::draw_dashed;
extern int Profile::draw_linewidth;
extern int Profile::draw_car_linewidth;
extern bool Profile::draw_label;

int main(int argc, char** argv)
{    
    ImageSource *input_source = NULL;
    bool show_images = true;
    char *output_movie = NULL;
    char *parameter_file = NULL;
    MovieStore* mv_out = NULL; 

    int last_frame = 0;
    int c;
    
    while ((c = getopt(argc, argv, "i:p:o:l:q")) != EOF)   // z:
	switch(c)
	{
	case 'i':
	    input_source = get_live_or_movie_feed(optarg);
	    break;
	    
	case 'p':
	    parameter_file = optarg;
	    break;
	    
	case 'o':
	    if (optarg != NULL) output_movie = optarg;
	    break;
	    
	case 'q':
	    show_images = false;
	    break;
	    
	case 'l':
	    last_frame = atoi(optarg);
	    break;
	    
	case '?':
	default:
	    fprintf(stderr, USAGE);
	    exit(1);
	}
    
    Configuration.parse_parameter_file(parameter_file);
    
    // set default icon for windows...
    Configuration.set_icon(simple_track_icon_16);
    
    if (show_images)
	Configuration.create_interface(argc, argv);
    
    ImageSource *vidsrc = input_source;
    
    if (vidsrc == NULL)
    {
	cerr << " multi_track: Please give video input source " << endl;
	exit(1);
    }
    
    TrackedProfileSet current_profiles;
    TrackedProfileSet static_profiles;  // static profiles removed from track
    TrackedProfileSet filtered_profiles;
    
    ActiveShapeTracker *people_tracker = 
	new ActiveShapeTracker(input_source,
				(char *) NULL,    // PCA file
				&current_profiles,
				(EdgeDetector*) NULL,
				&static_profiles);
    
    //Configuration.output_info();
    
    if (show_images)
	vidsrc->display();
    
    if (output_movie != NULL)
#ifdef LINUX
	mv_out = new MovieStore(MOVIESTORE_JPEG,output_movie);
#else
        mv_out = new MovieStore(output_movie, 0, true);
#endif
    
    /********************************************************************/
    /*                                                                  */
    /*                      Main Loop                                   */
    /*                                                                  */
    /********************************************************************/
    
    cout << NO_CONTROL_POINTS << " control_points " << endl;

    Profile::draw_linewidth = 4;
    Profile::draw_car_linewidth = 2;
    Profile::draw_label = true;
    
    while (vidsrc->get_current() != NULL) 
    {
	if ((last_frame != 0) && (vidsrc->get_frame_id() >= last_frame))
	    break;


	people_tracker->MainLoop(MAX_OBJECTS);


	cerr << " ///// Filtering " << current_profiles.no_items
	     << " current_profiles ... " << endl;
	
	filtered_profiles = 
	    current_profiles.filter_out_short(ActiveShapeTracker::SMALL_NO_FRAMES);

	cerr << " ///// ... yields " << filtered_profiles.no_items
	     << " filtered_profiles " << endl;
	
#ifndef NO_DISPLAY
	if (show_images)
	{
	    vidsrc->display();
/////	nts: CHANGED!	    current_profiles.draw();
	    Profile::draw_dashed = false;
	    filtered_profiles.draw();
	    //sleep(1);
	    //current_profiles.draw();
	    Profile::draw_dashed = true;
	    static_profiles.draw();
	    Profile::draw_dashed = false;
	}
	else
#endif   // #ifndef NO_DISPLAY
	{
	    fprintf(stderr,"\r frame %li ", vidsrc->get_frame_id());
	    fflush(stderr);
	}

	if (output_movie != NULL)
	{
/////	nts: CHANGED!    current_profiles.draw_in_image(vidsrc->get_current(),false);
	    Profile::draw_dashed = false;
	    filtered_profiles.draw_in_image(vidsrc->get_current(),false);
	    Profile::draw_dashed = true;
	    static_profiles.draw_in_image(vidsrc->get_current(),false);
	    mv_out->add_a_frame(vidsrc->get_current());
	}

	printf("*** frame %4li  ---  time %6.2f sec ***\n",
	       vidsrc->get_frame_id(),
	       (float) vidsrc->get_current_timestamp() / 1000);
	cout << " ------------------------------------------ " << endl;
	cout << " FILTERED: " << endl
	     << filtered_profiles;
	cout << " ------------------------------------------ " << endl;
	cout << " CURRENT: " << endl
	     << current_profiles;
	cout << " ------------------------------------------ " << endl;
	cout << " STATIC: " << endl
	     << static_profiles;
	cout << " ------------------------------------------ " << endl;
	
	filtered_profiles.delete_all();
	
#ifndef NO_DISPLAY
	gflush();
//	sleep(1);
#endif   // #ifndef NO_DISPLAY

	vidsrc->get_next();   // postincrement...
    }
    
    if (output_movie != NULL)
	delete mv_out;

    cout << endl;

    return 0;
}

// Local Variables:
// compile-command: "make multi_track |& fgrep :"
// End:
