/* test program */

#include <stdio.h>
#include <getopt.h>
#include "RegionSet.h"
#include "ProfileSet.h"
#include "RegionTracker.h"
#include <stdlib.h>
#include "utils.h"
#include "imgsrc_utils.h"
#include "MotionDetector.h"

#include "icons.h"

#define USAGE "get_reading_blobs -i [-n] [-p] [-q] \n\
-i option_string : input options (-i help for details)\n\
-n no_control_points: The number of spline control points \n\
-p parameter_file : for system parameters \n\
-q : quiet_mode : don't show images, GUI \n"



extern void setup_spline_matrices();


int main(int argc, char** argv)
{
    NO_CONTROL_POINTS = 32;
    Configuration.set_value("NO_BLOB_FILTER", false);
    Configuration.set_value("MIN_HEIGHT_TO_WIDTH", 0.1);
    Configuration.set_value("MAX_HEIGHT_TO_WIDTH", 1.1);
    Configuration.set_value("MAX_REGION_SIZE", 0.5);
    Configuration.set_value("BACKGROUND_RUN_LENGTH", 100);
    Configuration.set_value("NO_BLOB_FILTER", false);
    Configuration.set_value("MIN_REGION_SIZE", 0.01);
    
    Profile::draw_arrow = true;
    Profile::draw_boxes = false;
    Profile::draw_rectangle = true;
    
    ImageSource* input_source = NULL;
    bool show_images = true;
    
    int fhist = 
	Configuration.register_int("FRAME_HISTORY", 10,
			     &fhist, true, "main",
			     "Blobs most be successfully tracked over \
this many frames before being accepted as possible motion events");
    
    bool trace_regions =
	Configuration.register_bool("TRACE_BLOBS", false,
			      &trace_regions, true, "main",
			      "Trace the motion blobs and represent \
with a spline ?");
    int c;
    while ((c = getopt(argc, argv, "i:n:p:qh")) != EOF)
	switch(c)
	{
	    
	case 'i':
	    input_source = get_live_or_movie_feed(optarg);
	    break;
	    
	case 'n':
	    if (optarg != NULL) sscanf(optarg,"%d", &NO_CONTROL_POINTS);
	    trace_regions = true;
	    break;
	    
	case 'p':
	    Configuration.parse_parameter_file(optarg);
	    break;
	    
	case 'q':
	    show_images = false;
	    Configuration.set_value("SHOW_MOTION_IMAGES", false);	
	    break;
	case '?':
	case 'h':
	default:
	    fprintf(stderr,USAGE);
	    exit(1);
	} 
    
    if (show_images)
    {
  	// set default icon for windows...
  	Configuration.set_icon(get_reading_blobs_icon_16);
	Configuration.create_interface(argc, argv);
    }
    
    Profile::output_points = trace_regions;
    Profile::draw_spline = trace_regions;
    
    setup_spline_matrices();
    RegionTracker trk_regions = RegionTracker();
    
    cout << NO_CONTROL_POINTS << "control points" << endl;
    
    
    MotionDetector *mdetect = 
	new MotionDetector(input_source, get_reference_frame(),
                           1);              // don't resample background
    
    
    RegionSet* curr_regions = new RegionSet();
    RegionSet* old_regions = NULL;
    
    ProfileSet *buffer_profiles = new ProfileSet[fhist];
    int index = fhist-1;
    
    int nref = 1;
    for (int x=1; x >=0 ; x++)
    {
	if (mdetect->get_motion_image() == NULL)  // FIXME: nts: I guess...?
	    break;
	
	if (show_images)
	    input_source->display();
	
	mdetect->extract_new_regions(curr_regions, !trace_regions); 
	trk_regions.process_frame(curr_regions);
	curr_regions->label_regions(nref);
	
	if (trace_regions)
	    curr_regions->trace_regions();
	
	index = (index+1) % fhist;
	buffer_profiles[index].destroy_all();
	buffer_profiles[index] = curr_regions->to_profiles();
	buffer_profiles[index].scale_coords(mdetect->sample_skip);
	//buffer_profiles[index].remove_ok();
	
	ProfileSet* future_prfs = &buffer_profiles[index];
	ProfileSet* curr_prfs = 
	    &buffer_profiles[(index+1)%fhist];

	for (curr_prfs->start(); curr_prfs->current_ok(); curr_prfs->forward())
	{
	    Profile* tmp_prf =
		future_prfs->find_labelled(curr_prfs->get_current().ref_no);

	    if (tmp_prf != NULL)
		curr_prfs->get_current().direction 
		    = (tmp_prf->origin - curr_prfs->get_current().origin) / (fhist-1);
	}
	if (show_images) 
	{
	    input_source->get_current()->draw_in_image();
	    curr_prfs->draw();
	}
	
	
	if (x >= (fhist))
	{
	    int frame_no = x - (fhist-1);
	    cout << *curr_prfs << "**finished frame " << frame_no << 
		"**" << endl;;
	}
	
	if (old_regions != NULL)
	{
	    old_regions->destroy_all();
	    delete old_regions;
	}
	old_regions = curr_regions;
	curr_regions = new RegionSet();
    }
    return 0;
}


// Local Variables:
// DISABLEDcompile-command: "make data_extraction |& grep -v warning"
// compile-command: "make data_extraction"
// End:
