/***************************************************************
 * C++ source
 *
 * File : 	calibrate_ground_plane.cc
 *
 * Module :	calibrate_ground_plane
 *
 * Author : 	A M Baumberg (CoMIR)
 *
 * Creation Date : Wed Oct 30 17:20:04 1996 
 *
 * Comments : 	see below
 *
 ***************************************************************/



// simple interactive ground plane calibration 
// uses GL interface

#include "imgsrc_utils.h"
#include <getopt.h>

#include <gl/gl.h>
#include <gl/device.h>
#include "GroundPlaneToImagePlane.h"
#include <fstream.h>

#define USAGE "calibrate_ground_plane -i options \
[-o file] [-h] \n\
-i input_options: use -i help for more info \n\
-o output_file: optional parameter file for appending \n\
-h optionally use heights to calibrate ground plane \n\n\
Use following keys in display window ...\n\
<Left-Mouse>\t - select a point\n\
<Q>\t - With -h option: finish selecting points \n\
<SPACE>\t - With -h option: advance the input image by one frame \n\n\
All other input is via the keyboard in the shell terminal\n"

/* non-member functions */

long get_image_point (long& img_x, long& img_y)
//
// This routine uses the GL event loop to wait for the user to click the
// left mouse button on a point in the the given window. The x and y
// coordinates of this point are calculated and stored in img_x and img_y
//
// Also checks for QKEY (quit) and SPACEKEY (next frame)
// returns the device that caused the exit
    
{  
    Int32 minx;
    Int32 miny;
    Int32 x;
    Int32 y;
    Int32 width;
    Int32 height;
    long dev;
    short val;
    bool done = false;
    bool last_point = false;
    
    qdevice(LEFTMOUSE);
    qdevice(QKEY);
    qdevice(SPACEKEY);
    
    qreset();
    while (! done) {
	dev = qread(&val);
	switch (dev)
	{
	case LEFTMOUSE:
	{
	    if (val != 1)	// button-press
		break;
	    
	    // Retrieve coord of mouse click
	    
	    x = getvaluator( MOUSEX );
	    y = getvaluator( MOUSEY );
	    
	    getorigin(&minx, &miny);
	    getsize(&width, &height);
	    // Convert into Image x/y and display
	    
	    img_x = x-minx;
	    img_y = y-miny;
	    
	    cout << "x= " << img_x << " y=" << img_y << flush;
	    
	    done = true;
	    break;
	}
	case QKEY:
	case SPACEKEY:
	{
	    done = true;
	    while (qread(&val) != dev)
		/* nothing */;
	    break;    
	}
	}
    }
    return dev;
}


void get_world_point (realno& wld_u, realno& wld_v)
// 
// Prompt the user for a pair of world coordinates
//
{
    cout << endl << "World Point u coordinate ? " << flush;
    cin  >> wld_u;
    cout << "World Point v coordinate ? " << flush;
    cin  >> wld_v;
}


void show_points(Point2* pnts, int n)
{
    for (int j = 0; j < n; j++)
    {
	set_color(RED);
	circf(pnts[j].x, pnts[j].y, 2);
    }
}


int main (int argc, char** argv)
{
    int c;
    ImageSource* input_source = NULL;
    ostream* output_strm = &cout;
    bool use_heights = false;
    realno average_height;
//    gp_to_ip_register_variables();
    ofstream& outfile = *(new ofstream(optarg, ios::app)); 
    
    while ((c = getopt(argc, argv, "i:o:h")) != EOF)
	switch(c)
	{
	case 'i':
	    input_source = get_live_or_movie_feed(optarg);
	    break;
	    
	case 'o':
	    
	    if (outfile) output_strm = &outfile;
	    else 
	    {
		cerr << "Can't open " << optarg << endl;
		exit(1);
	    }
	    break;
	case 'h':
	    use_heights = true;
	    break;
	    
	case '?':
	default:
	    cerr << USAGE << endl;
	    exit(1);
	}	
    
    if (input_source == NULL)
    {
	cerr << USAGE << endl;
	exit(1);
    }
    
    input_source->get_next()->display();
    
    if (!use_heights)
    {
	Configuration.unmanage_variable("IP_TO_DEPTH_0");
	Configuration.unmanage_variable("IP_TO_DEPTH_1");
	Configuration.unmanage_variable("IP_TO_DEPTH_2");
	Point2 img_points[4];
	Point2 world_points[4];
	for (int i = 0; i < 4; i++)
	{
	    long img_x, img_y;
	    input_source->display();
	    show_points(img_points, i);
	    while (get_image_point(img_x, img_y) != LEFTMOUSE);
	    img_points[i] = Point2(img_x, img_y);
	    input_source->display();
	    show_points(img_points, i+1);
	    get_world_point(world_points[i].x, world_points[i].y);
	}
	
	setup_default_projection(img_points, world_points);
    }
    else
    {
	average_height = 
	    Configuration.register_real("AVERAGE_WORLD_HEIGHT", 180,
				  &average_height,
				  false, "GPfilter",
				  "Average world height (eg 180 cm)");
	Point2* img_points = new Point2[200];
	NagVector hghts(0,200);
	int i = 0;
	while (i < 200)
	{
	    long img_x, img_y;
	    long dev = 0;
	    input_source->display();
	    show_points(img_points, i);
	    cout << "\rClick on base point (foot) :  " << flush;
	    dev = get_image_point(img_x, img_y);
	    if (dev == QKEY)
		break;
	    if (dev == SPACEKEY)
	    {
		input_source->get_next()->display();
		continue;
	    }
	    img_points[i] = Point2(img_x, img_y);
	    show_points(img_points, i+1);
	    cout << "\rClick on top point (head) :  "<< flush;

	    while (get_image_point(img_x, img_y) != LEFTMOUSE)
		;

	    hghts.add(img_y - img_points[i].y);
	    cout << endl;
	    i++;
	}
	cout << "Now enter average world height (e.g. 180 cm) : " << flush;
	cin >> average_height;
	setup_default_projection(img_points, hghts, average_height);
    }

#ifdef DEBUG    
    cout << "Image Plane to Ground Plane transformation " << endl;
    ImagePlaneToGroundPlane.output();
    cout << "Ground Plane to Image Plane transformation " << endl;
    GroundPlaneToImagePlane.output();
#endif

    Configuration.dump_parameters(*output_strm);
    
    return 0;
}

